/*
 *  File: applibCommon.h
 *
 *  Description: As per the Apple sample programs, we break out
 *               common definitions needed in both resource (.r)
 *               and C++ (.cp) source files.
 */

#ifndef _applibCommon
#define _applibCommon


#define kPrefSize				700
#define kMinSize				600

#define	eWrongMachine			1
#define	eSmallSize				2
	
#define	kMinHeap				(512 * 1024)	 
#define	kMinSpace				(70 * 1024)

#define	eNoMemory				1
#define	eNoWindow				2

#define	rMenuBar	128
#define	rAboutAlert	128
#define	rDocWindow	128

#define	mApple					128		/* Apple menu */
#define	iAbout					1

#define	mFile					129		/* File menu */
#define	iNew					1
#define	iClose					4
#define	iQuit					12

#define	mApp					131		/* App menu */
#define	iGraph					1

#endif // _applibCommon
